/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.cmdprograms;

import com.tino1b2be.audio.AudioFileException;
import com.tino1b2be.dtmfdecoder.DTMFDecoderException;
import com.tino1b2be.dtmfdecoder.DTMFUtil;
import java.util.Scanner;

public class DTMFDecoder {
    private static String filename;

    public static void main(String[] args) throws AudioFileException, Exception {
        if (args.length == 2) {
            filename = args[0];
            DTMFUtil.setMinToneDuration(Integer.parseInt(args[1]));
        } else {
            DTMFDecoder.getInputFromUser();
        }
        DTMFUtil dtmf = new DTMFUtil(filename);
        dtmf.decode();
        String[] sequence = dtmf.getDecoded();
        if (dtmf.getChannelCount() == 1) {
            System.out.println("The DTMF tones found in the given file are: " + sequence[0]);
        } else {
            System.out.println("The DTMF tones found in channel one are: " + sequence[0] + "\nThe DTMF tones found in channel one are: " + sequence[1]);
        }
    }

    private static void getInputFromUser() {
        filename = "samples/stereo.wav";
        System.out.print("Please enter the filename for the audio file to be decoded: ");
        Scanner sc = new Scanner(System.in);
        filename = sc.nextLine();
        System.out.print("Please enter the minimum tone duration to be used for detection. (0 for default value): ");
        while (true) {
            try {
                double tone = Double.parseDouble(sc.nextLine());
                DTMFUtil.setMinToneDuration((int)tone);
            }
            catch (NumberFormatException e) {
                System.err.println("Input not a number. Please enter a valid number, decimals accepted. (0 or negative number to use default tone duration.)");
                continue;
            }
            catch (NullPointerException e) {
                System.err.println("Please enter a valid number, decimals accepted. (0 or negative number to use default tone duration.)");
                continue;
            }
            catch (DTMFDecoderException e) {
                System.err.println(e.getMessage());
                continue;
            }
            break;
        }
        sc.close();
    }
}

